/*
%
% Copyright 2012 NXP Semiconductors,
% 411 E Plumeria Dr San Jose CA USA
% All rights are reserved. Reproduction in whole or in part is prohibited
% without the prior written consent of the copyright owner.
%
*/

/*
+++ IDENTIFICATION

PACKAGE           : 
COMPONENT         : 
INTERFACE         : 
TEMPLATE VERSION  : 3
*/
#ifndef ROM_DRIVERS_H_
#define ROM_DRIVERS_H_

#ifdef DIVROMD_PRESENT
#include "divfuncs.h"

typedef	struct _DIVD {
    int32_t (*sdiv) (int32_t, int32_t);
    uint32_t (*udiv) (int32_t, int32_t);
    sdiv_t (*sdivmod) (int32_t, int32_t);
    udiv_t (*udivmod) (uint32_t, uint32_t);
}  DIVD;
#endif /* DIVROMD_PRESENT */

#ifdef PWRROMD_PRESENT
#include "power_control.h"
#endif /* PWRROMD_PRESENT */

#ifdef I2CROMD_PRESENT
#include "hw_i2cd_rom_api.h"  
#endif

#ifdef UARTROMD_PRESENT
#include "hw_uartd_rom_api.h"  
#endif

#ifdef DMAROMD_PRESENT
#include "hw_dmad_rom_api.h"  
#endif

#ifdef USBROMD_PRESENT
#include "mw_usbd_rom_api.h"
#endif

#ifdef CANROMD_PRESENT
#include "rom_driver_CAN.h"
#endif /* CANROMD_PRESENT */

typedef	struct _ROM {
#ifdef USBROMD_PRESENT
   const USBD_API_T * pUSBD;
#else
   const unsigned p_usbd;
#endif /* USBROMD_PRESENT */

   const unsigned p_clib;
#ifdef CANROMD_PRESENT	
	 const CAND * pCAND;
#else
   const unsigned p_cand;
#endif
	
#ifdef PWRROMD_PRESENT
   const PWRD * pPWRD;
#else
   const unsigned p_pwrd;
#endif /* PWRROMD_PRESENT */

#ifdef DIVROMD_PRESENT
   const DIVD * pDIVD;
#else
   const unsigned p_promd;
#endif /* DIVROMD_PRESENT */

#ifdef I2CROMD_PRESENT
   const I2CD_API_T * pI2CD;
#else
   const unsigned p_i2cd;
#endif /* I2CROMD_PRESENT */

#ifdef DMAROMD_PRESENT    
   const DMAD_API_T * pDMAD;
#else
   const unsigned p_dmad;
#endif /* DMAROMD_PRESENT */

	const unsigned p_empty0; //available for future driver
  const unsigned p_empty1; //available for future driver

#ifdef UARTROMD_PRESENT
	 const UARTD_API_T * pUARTD;
#else
	 const unsigned p_uartd;
#endif /* UARTROMD_PRESENT */

}  ROM;

#endif /*ROM_DRIVERS_H_*/
